-- Mandate_Of_Heaven.lua
-- Author: Machiavelli
-- DateCreated: 5/30/2012 4:34:27 PM
--------------------------------------------------------------
function GivePromotionIfGoldenAge(playerID, unitID, hexVec, unitType, cultureType, civID, primaryColor, secondaryColor, unitFlagIndex, fogState, selected, military, notInvisible)
	local player = Players[playerID];
	local unit = player:GetUnitByID(unitID);
	local policyID = GameInfoTypes["POLICY_MANDATE_OF_HEAVEN"];
	local promotionID = GameInfo.UnitPromotions["PROMOTION_MANDATE_OF_HEAVEN"].ID;

	-- Only give the promotion if the player has the policy and is in a golden age and the unit is a military unit
	if(player:HasPolicy(policyID) and not player:IsPolicyBlocked(policyID) and player:IsGoldenAge() and unit:IsCombatUnit()) then
		unit:SetHasPromotion(promotionID, true);
	end
end
LuaEvents.SerialEventUnitCreatedGood.Add(GivePromotionIfGoldenAge);